#!/bin/sh

RETURN_CODE=0
# current directory: /mnt/nand/update/update.sh

DATESTAMP=$(date +'%Y-%m-%d %H:%M:%S')
echo "$DATESTAMP : Start of update.sh"
echo "current directory:"
pwd

echo "Waiting for extract_ramdisk.sh to finish"
while pidof extract_ramdisk.sh; do
    sleep 1
done

if [ ! -d /mnt/nand/update ]; then
    exit $RETURN_CODE
fi

#TODO Add detect current version / kernel
currentver="$(uname -r)"
requiredver="4.19.59"
if [ "$(printf '%s\n' "$requiredver" "$currentver" | sort -V | head -n1)" != "$requiredver" ]; then
    echo "Cannot apply update, need to upgrade kernel first"
    exit $RETURN_CODE
fi

export FORCE_REBOOT=0
(cat /mnt/nand/polaris.sh | grep -q 'FORCE_REBOOT') && FORCE_REBOOT=1
echo FORCE_REBOOT=$FORCE_REBOOT

md5sum -c checksum.lst
if [ $? -ne 0 ]; then
    echo "checksum test failed"
    exit $RETURN_CODE
fi

# update wifi to /mnt/nand/wifi/
if [ -e ../wifi/wpa_supplicant.conf ]; then
    echo "Backing up user wifi settings..."
    cp ../wifi/wpa_supplicant.conf ../wifi/wpa_supplicant.conf_user
fi

if [ -d nandfs ]; then
    echo "updating nandimage..."
    cp -af nandfs/. /mnt/nand
    chown -R root:root /mnt/nand
    RETURN_CODE=1
fi

# kernel update
if [ -e uImageRD-no-dtb ]; then
    echo "Updating kernel"
    cp -f uImageRD-no-dtb /mnt/nand/uImageRD
    RETURN_CODE=1
elif [ -e uImageRD ]; then
    echo "Updating kernel"
    cp -f uImageRD /mnt/nand/uImageRD
    RETURN_CODE=1
fi

# dtb update
if [ -e am335x-evm.dtb ]; then
    echo "Updating dtb"
    cp -f am335x-evm.dtb /mnt/nand/am335x-evm.dtb
    RETURN_CODE=1
fi

if [ -e ../wifi/wpa_supplicant.conf_user ]; then
    echo "Restoring user wifi settings..."
    mv ../wifi/wpa_supplicant.conf_user ../wifi/wpa_supplicant.conf
fi

if [ -e MLO-nand16 ]; then
    echo "Updating U-boot(SPL) 1 of 4"
    /mnt/nand/rootfs/usr/sbin/flash_erase /dev/mtd0 0 0
    /usr/sbin/nandwrite -p /dev/mtd0 MLO-nand16
    echo "Updating U-boot(SPL) 2 of 4"
    /mnt/nand/rootfs/usr/sbin/flash_erase /dev/mtd1 0 0
    /usr/sbin/nandwrite -p /dev/mtd1 MLO-nand16
    echo "Updating U-boot(SPL) 3 of 4"
    /mnt/nand/rootfs/usr/sbin/flash_erase /dev/mtd2 0 0
    /usr/sbin/nandwrite -p /dev/mtd2 MLO-nand16
    echo "Updating U-boot(SPL) 4 of 4"
    /mnt/nand/rootfs/usr/sbin/flash_erase /dev/mtd3 0 0
    /usr/sbin/nandwrite -p /dev/mtd3 MLO-nand16
    RETURN_CODE=1
fi

if [ -e u-boot-nand16.img ]; then
    echo "Updating U-boot"
    /mnt/nand/rootfs/usr/sbin/flash_erase /dev/mtd4 0 0
    /usr/sbin/nandwrite -p /dev/mtd4 u-boot-nand16.img
    RETURN_CODE=1
fi

# clear mtd6
if [ -e uImageRD-no-dtb ]; then
    echo "Clearing mtd6"
    /mnt/nand/rootfs/usr/sbin/flash_erase /dev/mtd6 0 0
    RETURN_CODE=1
elif [ -e uImageRD ]; then
    echo "Clearing mtd6"
    /mnt/nand/rootfs/usr/sbin/flash_erase /dev/mtd6 0 0
    RETURN_CODE=1
fi

# remove obexd
echo "removing obexd..."
test -f /mnt/nand/rootfs/usr/libexec/obexd && rm /mnt/nand/rootfs/usr/libexec/obexd

# update favourite packs
FAV_VERSION=1
if [ -f /mnt/nand/fav_version ];
then
    CURRENT_FAV_VERSION=`cat /mnt/nand/fav_version`
else
    CURRENT_FAV_VERSION=0
fi
echo "New favourites: $FAV_VERSION"
echo "Current favourites: $CURRENT_FAV_VERSION"
if [[ $FAV_VERSION -ne $CURRENT_FAV_VERSION ]];
then
    echo "Updating favourite packs"
    cd /mnt/nand
    (sleep 10 && killall PolarisQtApp) &   # Fallback in case PolarisQtApp hangs for any reason
    LD_LIBRARY_PATH=/mnt/nand/Qt/lib /mnt/nand/PolarisQtApp -updatefavs -qws >> /mnt/nand/fav_update.log 2>&1
    cd -
    echo $FAV_VERSION >> /mnt/nand/fav_version
    rm /mnt/nand/terminated.marker
fi


# polaris.sh doesn't support FORCE_REBOOT yet, so force reboot to ensure Kernel and SSL work immediately.
if [ $FORCE_REBOOT -eq 0 ]; then
    echo "Deleting /mnt/nand/update/"
    cd /mnt/nand/ && rm -rf /mnt/nand/update
    sync
    echo "Doing reboot..."
    reboot
fi

echo "end of update.sh, return code:$RETURN_CODE"
exit $RETURN_CODE
