#!/bin/sh
# Copyright (C) 2013,2014 Tru-Test Ltd.  All rights reserved.

if [ $# -eq 0 ]
# No arguements, just start the interface
then
    if [ ! -f /tmp/wifi_init_done ]
    then
        echo Ensuring clean start state
        killall_udhcpd_wlan
        killall_dnsmasq
        (pgrep hostapd > /dev/null) && (echo Stopping hostapd...; pkill hostapd && echo "OK")
        iptables -t nat -F

        ln -sf /mnt/nand/rootfs/lib/firmware/regulatory.db /lib/firmware
        ln -sf /mnt/nand/rootfs/lib/firmware/regulatory_fcc.db /lib/firmware

        wifimodule=0
        if grep -qi 0x02d0 /tmp/wifivendor
        then
            wifimodule=1
        elif grep -qi 0x0097 /tmp/wifivendor
        then
            wifimodule=0
        fi
        if [ $wifimodule -eq 0 ]
        then
            echo Starting wl12xx driver...

            ln -sf /mnt/nand/rootfs/lib/firmware/ti-connectivity /lib/firmware/

            mkdir -p /usr/share/ti
            ln -sf /mnt/nand/rootfs/usr/share/ti/wifi-utils /usr/share/ti

            depmod -a
            modprobe cfg80211
            modprobe mac80211
            modprobe wlcore
            modprobe wl12xx

            #if [ -f /lib/firmware/ti-connectivity/wl1271-nvs.bin ]
            #then
            #    echo Deleting old calibration
            #    rm /lib/firmware/ti-connectivity/wl1271-nvs.bin
            #fi

            # You need to remove wl12xx_sdio before calibrating
            #rmmod wlcore_sdio

            ##export WL12xx_SDIO_KO=/lib/modules/$(uname -r)/updates/drivers/net/wireless/wl12xx/wl12xx_sdio.ko
            #export WLCORE_SDIO_KO=/lib/modules/$(uname -r)/kernel/drivers/net/wireless/ti/wlcore/wlcore_sdio.ko
            ## 930-0056 = ETSI
            #export WL12xx_INI=/usr/share/ti/wifi-utils/ini_files/127x/930-0056-R1.0.ini
            #export WL12xx_NVS=/lib/firmware/ti-connectivity/wl1271-nvs.bin

            ## Address 00:00:00:00:00:00 means use address in module for MAC.
            #sleep 1
            ##echo Running calibrator: $WL12xx_INI
            #calibrator plt autocalibrate wlan0 $WLCORE_SDIO_KO $WL12xx_INI $WL12xx_NVS 00:00:00:00:00:00 > /dev/null
            #sleep 1

            # start wifi again
            modprobe wlcore_sdio
        else
            echo Starting Broadcom driver

            ln -sf /mnt/nand/rootfs/lib/firmware/brcm /lib/firmware

            depmod -a
            #rmmod bluetooth
            #rmmod compat
            #insmod /lib/modules/4.19.59-g5f8c1c6121/updates/compat/compat.ko
            insmod /lib/modules/4.19.59-g5f8c1c6121/updates/net/wireless/cfg80211.ko
            insmod /lib/modules/4.19.59-g5f8c1c6121/updates/drivers/net/wireless/broadcom/brcm80211/brcmutil/brcmutil.ko
            insmod /lib/modules/4.19.59-g5f8c1c6121/updates/drivers/net/wireless/broadcom/brcm80211/brcmfmac/brcmfmac.ko
            sleep 1
        fi

        # iw dev wlan0 scan | grep SSID

        # start udhcpd server, 192.168.8.1
        mkdir -p /var/lib/misc/
        touch /var/lib/misc/udhcpd_wlan0.leases

        cat > /etc/udhcpd_wlan0.conf << HEREDOC
start      192.168.8.10
end        192.168.8.20
opt dns    192.168.8.1
opt router 192.168.8.1
interface  wlan0
max_leases 10
option subnet 255.255.255.0
pidfile /var/run/udhcpd_wlan0.pid
lease_file /var/lib/misc/udhcpd_wlan0.leases
HEREDOC


        mkdir -p /var/run/hostapd

        mac=`devmem 1155597872 64`
        shortid=`echo ${mac:16:2}${mac:14:2}`
        grep -v ^ssid= /mnt/nand/wifi/hostapd.conf > /etc/hostapd.conf
        if grep -qi model=XR5000 /tmp/model
        then
            echo ssid=XR5000-$shortid >> /etc/hostapd.conf
        elif grep -qi model=ID5000 /tmp/model
        then
            echo ssid=ID5000-$shortid >> /etc/hostapd.conf
        else
            echo ssid=JR5000-$shortid >> /etc/hostapd.conf
        fi

        echo > /tmp/wifi_init_done
    fi
fi

killall_dnsmasq ()
{
    if [ -f /var/run/dnsmasq.pid ]
    then
        kill $(cat /var/run/dnsmasq.pid)
        sleep 1
    fi

    # stale?
    if [ -f /var/run/dnsmasq.pid ]
    then
        rm -f /var/run/dnsmasq.pid
    fi
}

killall_wpasupplicant ()
{
    if [ -f /var/run/wpa_supplicant.pid ]
    then
        kill $(cat /var/run/wpa_supplicant.pid)
        sleep 1
    fi

    # stale?
    if [ -f /var/run/wpa_supplicant.pid ]
    then
        rm -f /var/run/wpa_supplicant.pid
    fi
    killall wpa_supplicant
}

killall_udhcpd_wlan ()
{
    # running?
    if [ -f /var/run/udhcpd_wlan0.pid ]
    then
        kill $(cat /var/run/udhcpd_wlan0.pid)
        sleep 1
    fi

    # stale?
    if [ -f /var/run/udhcpd_wlan0.pid ]
    then
        rm -f /var/run/udhcpd_wlan0.pid
    fi

    # any more?
    for i in 1 2 3 4 5
    do
        udhcpd_pid=`ps | grep "[/]mnt/nand/rootfs/usr/sbin/udhcpd -S /etc/udhcpd_wlan0.conf"  | tr " " "\n" | grep -v ^$ | head -1`
        if [ "$udhcpd_pid" == "" ]
        then
            break
        fi
        kill $udhcpd_pid
        sleep 1
    done
}

if [ "$1" == "on" ]
then
    # start access point...
    echo Starting WiFi access point
    # udhcpd shouldn't be running, but make sure:
    killall_udhcpd_wlan

	# configure as Soft AP...
    ifconfig wlan0 add 192.168.8.1 netmask 255.255.255.0 up

    # clear up old lease file:
    if [ -f /var/lib/misc/udhcpd_wlan0.leases ]
    then
        echo Deleting old leases
        rm /var/lib/misc/udhcpd_wlan0.leases
    fi
    touch /var/lib/misc/udhcpd_wlan0.leases

    # start up udhcpd and hostapd:
    udhcpd -S /etc/udhcpd_wlan0.conf
    (pgrep hostapd > /dev/null) || (echo Starting hostapd...; hostapd -B /etc/hostapd.conf && echo "OK")


    # Configure IP routing, and start DNS server
    iptables -t nat -F
    iptables -t nat -A PREROUTING -i wlan0 -p tcp -m tcp --dport 80 -j DNAT --to :9000
    iptables -t nat -A PREROUTING -i wlan0 -d 8.8.8.8/32 -j DNAT --to-destination 192.168.8.1
    iptables -t nat -A PREROUTING -i wlan0 -d 8.8.4.4/32 -j DNAT --to-destination 192.168.8.1
    iptables -t nat -A POSTROUTING -j SNAT --to-source 192.168.8.1
    dnsmasq --address=/#/192.168.8.1 --no-dhcp-interface=wlan0 -q -a 192.168.8.1
fi

if [ "$1" == "off" ]
then
    echo Killing WiFi access point
    # stop access point:
    killall_udhcpd_wlan
    killall_dnsmasq
    killall_wpasupplicant
    killall udhcpc
    # Remove the ip address
    ip addr flush wlan0

    (pgrep hostapd > /dev/null) && (echo Stopping hostapd...; pkill hostapd && echo "OK")
    iptables -t nat -F
fi

if [ "$1" == "station" ]
then
    killall_dnsmasq
    (pgrep hostapd > /dev/null) && (echo Stopping hostapd...; pkill hostapd && echo "OK")
    iptables -t nat -F
    
    echo Starting WPA_supplicant
    /mnt/nand/wifi/wpa_supplicant -Dnl80211 -iwlan0 -c/mnt/nand/wifi/wpa_supplicant.conf -P/var/run/wpa_supplicant.pid -B
fi




ifconfig wlan0 | head -2

