#!/bin/sh
# Copyright (C) 2013,2014 Tru-Test Ltd.  All rights reserved.

#
# This script is started from /etc/init.d/rcS after mounting the NAND partition /mnt/nand.
# It is stored as /mnt/nand/startup.sh

echo Splash screen...
zcat /etc/ttlogo_step_5.ppm.gz | fbsplash -s -

# Disable the frame buffer console on the LCD
# to avoid spurious text on the LCD e.g. from HID type barcode scanners
for d in /sys/devices/virtual/vtconsole/vtcon*
do
    grep -q "frame buffer" $d/name && echo 0 > $d/bind
done


# We need /dev/pts for remote login (e.g. telnet, getty, bluetooth):
# Should be mounted by /etc/init.d/rcS
mkdir -p /dev/pts
(mount | grep -q ^devpts) || (echo Mounting /dev/pts...; mount devpts /dev/pts -t devpts)

# Change to true for a login prompt on ttyS0 at 115200 baud, or false to enable the application serial port at 9600 baud
if grep -q getty /proc/cmdline; then
    echo Starting getty for root shell access..
    echo root::0:0:root:/home/root:/bin/sh > /etc/passwd
    # restart init without shell on console, instead getty on tty0:
    echo ::sysinit:/etc/init.d/rcS > /etc/inittab
    echo ::respawn:/sbin/getty -L ttyS0 115200 vt100 >> /etc/inittab
    echo ::ctrlaltdel:/sbin/reboot >> /etc/inittab
    echo ::shutdown:/sbin/swapoff -a >> /etc/inittab
    echo ::shutdown:/bin/umount -a -r >> /etc/inittab
    echo ::restart:/sbin/init >> /etc/inittab
    kill -HUP 1
else
    ln -s /dev/ttyS0 /dev/ttySP1
fi

# old kernel build mounted spidev as "1", keep for backwards compatiability
ln -s /dev/spidev0.0 /dev/spidev1.0

# setup qt libs
mkdir -p /usr/local/Trolltech /usr/lib /tmp /opt
ln -s /mnt/nand/Qt-am335xfbvnc-4.7.4 /usr/local/Trolltech/Qt-am335xfbvnc-4.7.4
ln -s /usr/local/Trolltech/Qt-am335xfbvnc-4.7.4 /opt/qt-am335x

# copy standard libraries
ln -s /mnt/nand/rootfs/lib/ld* /lib
ln -s /mnt/nand/rootfs/lib/lib* /lib
ln -s /mnt/nand/rootfs/lib/systemd /lib
ln -s /mnt/nand/rootfs/usr/lib/lib* /usr/lib
mkdir -p /usr/libexec
ln -s /mnt/nand/rootfs/usr/libexec/* /usr/libexec
ln -s /mnt/nand/rootfs/usr/sbin/dropbearmulti /usr/bin/scp
ln -s /mnt/nand/ssl /usr/lib/ssl

echo Adding /rootfs/bin and /rootfs/sbin to the path...
export PATH=/sbin:/usr/sbin:/mnt/nand/rootfs/sbin:/mnt/nand/rootfs/usr/sbin:/bin:/usr/bin:/mnt/nand/rootfs/bin:/mnt/nand/rootfs/usr/bin
echo export PATH=/sbin:/usr/sbin:/mnt/nand/rootfs/sbin:/mnt/nand/rootfs/usr/sbin:/bin:/usr/bin:/mnt/nand/rootfs/bin:/mnt/nand/rootfs/usr/bin > /etc/profile

# Extra safety against kernel hangs... this should cause any oops/panic to reboot (instead of hang).
echo 1 > /proc/sys/kernel/panic
echo 1 > /proc/sys/kernel/panic_on_oops

# The Watchdog seems good at catching suspend/standby hangs (e.g. BT rfcomm related), and rebooting the system.
# The watchdog is disabled just before standby, and re-enabled by the kernel when it wakes up.
watchdog -T 10 -t 1 /dev/watchdog

echo Enabling LCD...
# These are enabled already by rcS, so no need to do it again...
# GPIO 99  = GPIO3_3 = LCD Power Enable
# GPIO 100 = GPIO3_4 = Backlight Power Enable
cd /sys/class/gpio
if [ ! -d gpio99 ]
then 
    echo Exporting gpio99
    echo 99 > export
    echo high > gpio99/direction
fi
if [ ! -d gpio100 ]
then 
    echo Exporting gpio100
    echo 100 > export
    echo high > gpio100/direction
fi
cd /

cd /mnt/nand

# serial ports:
if [ ! -e /dev/ttySP0 ]
then 
    # The S1A prototypes have ttyS1 as the second serial port on the C16.
    # On the S2 prototypes, the second serial port is UART4.
    ln -s /dev/ttyS4 /dev/ttySP0
fi


# charger is on /dev/i2c-2 (i.e. I2C1).
echo Setting float voltage to 3.60V and 2A: i2cset -y 2 0x09 0x02 0x98
i2cset -y 1 0x09 0x02 0x98

echo Disabling UVCL: i2cset -y 2 0x09 0x00 0x80
i2cset -y 1 0x09 0x00 0x80


# pre-made ramdisk image.
rm -f /tmp/disk.img*
rm -f /mnt/nand/disk.img
#cp /mnt/nand/disk.img.gz /tmp/
gzip -dk /mnt/nand/disk.img.gz
ln -s /mnt/nand/disk.img /tmp/disk.img

# folders
mkdir -p /mnt/nand/logfiles /mnt/nand/favourites /mnt/nand/helpmanual
mkdir -p /mnt/nand/animaldatainterface


# start telnetd
(pgrep telnetd > /dev/null) || (echo Starting telnetd...; /etc/init.d/telnetd start)

# Start ssh
if [ ! -e /mnt/nand/dropbear.rsa ]
then 
    echo "Creating SSH Key"
    /mnt/nand/rootfs/usr/sbin/dropbearkey -t rsa -f /mnt/nand/dropbear.rsa
fi

# Linking /mnt/nand/.ssh to root account
mkdir -p /mnt/nand/.ssh
ln -s /mnt/nand/.ssh /home/root/.ssh

(pgrep dropbear > /dev/null) || (echo Starting sshd...; /mnt/nand/rootfs/usr/sbin/dropbear -B -r /mnt/nand/dropbear.rsa)

# Detection of WiFi chipset
cat /sys/bus/mmc/devices/mmc1\:0001/mmc1\:0001\:1/vendor > /tmp/wifivendor
if grep -qi 0x02d0 /tmp/wifivendor
then
    echo "Detected BRCM wifi chipset"
elif grep -qi 0x0097 /tmp/wifivendor
then
    echo "Detected TI wifi chipset"
fi

# Setup BT early.
cd /mnt/nand/rootfs
cp -a etc/bluetooth /etc
cp -a etc/dbus-1 /etc
cp -a etc/init.d/dbus-1 /etc/init.d/
cp -a etc/group /etc
cat etc/passwd | grep -v ^root: >> /etc/passwd

# Setup iptables
cp -ar usr/lib/xtables/ /usr/lib
cp /mnt/nand/rootfs/etc/hosts /etc/hosts
echo '1' > /proc/sys/net/ipv4/ip_forward
mkdir -p /run
iptables -t nat -A PREROUTING -p tcp -m tcp --dport 80 -j REDIRECT --to-ports 9000
iptables -t nat -A PREROUTING -d 8.8.8.8/32 -j DNAT --to-destination 192.168.8.1
iptables -t nat -A PREROUTING -d 8.8.4.4/32 -j DNAT --to-destination 192.168.8.1
iptables -t nat -A POSTROUTING -j SNAT --to-source 192.168.8.1

mkdir -p /var/run/dbus

/mnt/nand/rootfs/sbin/dnsmasq --address=/#/192.168.8.1 --no-dhcp-interface=wlan0 -a 192.168.8.1

# The /etc/init.d/dbus-1 script checks for /usr/bin/dbus-daemon:
ln -s /mnt/nand/rootfs/usr/bin/dbus-daemon /usr/bin/dbus-daemon
mkdir -p /usr/share
ln -s /mnt/nand/rootfs/usr/share/dbus-1 /usr/share/dbus-1

# For persistence of Bluetooth pairing and other info to nand fs
mkdir -p /mnt/nand/vlb
mkdir -p /var/lib
ln -s /mnt/nand/vlb /var/lib/bluetooth

echo Starting dbus
touch /etc/init.d/functions
mkdir -p /usr/var/lib/dbus
mkdir -p /usr/var/run/dbus
/etc/init.d/dbus-1 start

dbus-launch --auto-syntax > /tmp/bt-demo-env
. /tmp/bt-demo-env

ln -s /var/run/dbus/system_bus_socket /usr/var/run/dbus/

modprobe compat
#start systemd
sed s@^NOPLUGIN_OPTION=\"\"@NOPLUGIN_OPTION=\"--compat\"@ -i /etc/init.d/bluetooth
/etc/init.d/bluetooth start
sleep 1
modprobe bluetooth
modprobe gpio_en
# There needs to be a few seconds between "modprobe gpio_en" (above) and doing hciattach (in bt.sh).
# This ensures that the firmware in the BT module has started up.
# hciattach is done in bt.sh after PolarisQtApp starts running, which gives sufficient delay.

# This part is run in the background to allow startup.sh to finish.
cd /mnt/nand
/mnt/nand/polaris.sh &


