#!/usr/bin/env python3

import yaml
import hashlib
from os import listdir
from os.path import splitext
from xml.dom.minidom import parse

data = {"en": {}}

def generate_key(keystr):
    hash = hashlib.md5(keystr.encode())
    return hash.hexdigest()

def generate_yaml_translation(fname):

    document = parse(fname)

    splitfname = splitext(fname)[0]

    try:
        header = document.getElementsByTagName("Header")[0]
        name = header.getElementsByTagName("Name")[0].firstChild.nodeValue
        if name != splitfname:
            key = generate_key(name)
            data["en"][key] = name
        key = generate_key(header.getElementsByTagName("Description")[0].firstChild.nodeValue)
        data["en"][key] = header.getElementsByTagName("Description")[0].firstChild.nodeValue
    except IndexError:
        pass

    for device in document.getElementsByTagName("device"):
        key = generate_key(device.getAttribute("label"))
        data["en"][key] = device.getAttribute("label")

    for rule in document.getElementsByTagName("DraftRule"):
        key = generate_key(rule.getAttribute("label"))
        data["en"][key] = rule.getAttribute("label")

    for element in document.getElementsByTagName("DataField"):
        key = generate_key(element.getAttribute("description"))
        data["en"][key] = element.getAttribute("description")
        key = generate_key(element.getAttribute("label"))
        data["en"][key] = element.getAttribute("label")

    for element in document.getElementsByTagName("list_of_values"):
        key = generate_key(element.firstChild.nodeValue)
        data["en"][key] = element.firstChild.nodeValue

if __name__ == "__main__":

    files = []
    dirs = [
        "id_en_nz",
        "jr_en_nz",
        "xr_en_nz",
    ]
    for d in dirs:
        for f in listdir(d):
            if splitext(f)[1] == ".ttfav":
                files.append(d + "/" + f)

    for f in files:
        generate_yaml_translation(f)

    with open("extra_favourites.yaml", 'w') as outf:
        outf.write(yaml.dump(data, Dumper=yaml.CDumper))

