
import sys
import yaml

def main():

    with open(sys.argv[1]) as f1:
        yaml1 = yaml.load(f1.read(), Loader=yaml.CLoader)

    with open(sys.argv[2]) as f2:
        yaml2 = yaml.load(f2.read(), Loader=yaml.CLoader)

    dupcount = 0
    deduplicated = {}
    deduplicated['en'] = {}
    for key, value in yaml1['en'].items():
        if key in yaml2['en']:
            print("Dup {}, {}".format(key, value))
            dupcount += 1
        else:
            deduplicated['en'][key] = value

    print("Duplicates: {}/{}".format(dupcount, len(yaml1['en'])))

    print(deduplicated)
    with open(sys.argv[1], 'w') as fout:
        fout.write(yaml.dump(deduplicated, Dumper=yaml.CDumper))

if __name__ == "__main__":
    main()
