#!/bin/sh
# Copyright (C) 2013,2014 Tru-Test Ltd.  All rights reserved.

# This script is run at these two times:
#
# 1:  When the user disconnects the USB cable to the PC (i.e. when the "USB connected" dialog is shown)
#
# 2:  By polaris.sh after PolarisQtApp closes, in the event that the ramdisk is still exposed to the USB MSD gadget.
#     IE The app closed while the "USB connected" was showing and it didn't extract the ramdisk

# It needs to handle copying the DB, Polaris updates, favourites, etc.

# It is the responsibility of the caller of the script to first disconnect the ramdisk from the MSD gadet.
# IE Do: "echo > /sys/bus/platform/devices/musb-hdrc.0/gadget/lun0/file"

# mount /tmp/disk.img on /mnt/rd:
LOOPDEV=`losetup -f`
losetup -o 1048576 $LOOPDEV /tmp/disk.img
mkdir -p /mnt/rd
mount $LOOPDEV /mnt/rd

# Copy favourites from ramdisk to NAND:
mkdir -p /mnt/nand/favourites
find /mnt/rd/favourites -maxdepth 1 -name \*.ttfav -exec cp -f '{}' /mnt/nand/favourites \;

# Look for new firmware in /mnt/rd, and select the newest one:
tgzfile=$(find /mnt/rd -name update\*.tgz -maxdepth 1 | sort -rn | head -n 1)

# Check and extract firmware:
if [ -z $tgzfile ]
then
    echo No firmware found.
else
    echo Found firmware: $tgzfile
    if gunzip -t $tgzfile
    then
        echo Firmware OK
        cp -f PolarisQtApp PolarisQtApp_bak

        # This will extract the firmware into /mnt/nand/update:
        rm -rf /mnt/nand/update
        tar xzf $tgzfile -C /mnt/nand
        if [ $? -eq 0 ];then
          echo "successfully unzipped $tgzfile"
          cd /mnt/nand/update
          md5sum -c checksum.lst
          if [ $? -eq 0 ];then
            echo "successfully extracted update directory"
          else
            echo "checksum test failed"
            rm -rf /mnt/nand/update
          fi
          cd -
        else
          echo "failed to unzip $tgzfile"
        fi

        # The actual update is done in polaris.sh (i.e. detect and execute /mnt/nand/update/update.sh)
        # This ensures that the PolarisQtApp is not running during the update.
    else
        echo Corrupted firmware detected
    fi

    rm -f /mnt/rd/update*.tgz
    sync
fi

# Update SSL files:
if [ -d /mnt/rd/ssl ]; then
    echo "Updating SSL files"
    cp -rfd /mnt/rd/ssl/ /mnt/nand/
fi

# Update settings_current.ttfav
if test -e /mnt/rd/settings_current.ttfav
then
        echo settings_current.ttfav found
        cp /mnt/rd/settings_current.ttfav /mnt/nand/settings_current_new.ttfav && sync
fi

# Update translation files:
find /mnt/rd -maxdepth 1 -name \*.qm -exec cp -f '{}' /mnt/nand \;

# Check for a new DB:
if test -e /mnt/rd/db
then
    echo found db
    if cmp -s /mnt/nand/db /mnt/rd/db
    then
        echo db not modified
    else
        if test -e /mnt/rd/db-journal
        then
            echo db-journal found, something has gone wrong, deleting journal and DB file
            rm /mnt/rd/db-journal
            rm /mnt/rd/db
        else
			echo different, and complete, copy in
			cp /mnt/rd/db /mnt/nand/newdb && sync
            echo no db-journal found
        fi
    fi
    rm -f /mnt/rd/db
    rm -f /mnt/rd/db-journal
else
    echo Missing /mnt/rd/db
fi

if test -e /mnt/rd/db_working
then
	echo db_working file left behind, unexpected
	rm /mnt/rd/db_working
fi
if test -e /mnt/rd/db_working-journal
then
	echo db_working-journal file left behind, unexpected
	rm /mnt/rd/db_working-journal
fi


# Check for adc playback files:
if test -e /mnt/rd/logfiles/adc.log
then
    echo adc.log exists
    mkdir -p /tmp/logfiles
    echo Creating logfiles dir, and moving file.
    mv -f /mnt/rd/logfiles/adc.log /tmp/logfiles/
else
    echo no adc.log found
    # If adc.log is delete in massive storage mode, we do nothing on /tmp/logfiles/adc.log
    # Therefore Settings > Service > Logging > Delete Log is the only way to delete adc.log in all places.
fi

# check for do_db_fixes marker
if test -e /mnt/rd/do_db_fixes
then
    echo do_db_fixes exists
    rm /mnt/nand/db_fix
    rm /mnt/nand/restart

# move back any undeleted telemetry files
if test -e /mnt/rd/telemetry/
then
    echo "telemetry directory exists"
    mkdir -p /mnt/nand/telemetry
    echo "moving remaining telemetry files back to device"
    mv -f /mnt/rd/telemetry/*.log /mnt/nand/telemetry/
    chmod -x /mnt/nand/telemetry/*.log
else
    echo "no telemetry directory"
fi

# Finished.
umount $LOOPDEV

# BusyBox umount disassociates the loopdev automatically.
# losetup -d $LOOPDEV


# cd /mnt/nand/update/
# chmod a+x update.sh
# ./update.sh > ../update.log
# cd ../

