#!/bin/sh
# Copyright (C) 2013,2014 Tru-Test Ltd.  All rights reserved.

while true
do
    for d in `hcitool -i hci0 con | tr " " "\n" | grep ..:..:..:..:..:..`
    do 
        echo Check $d...
        st1=$(date +%s)
        l2ping -i hci0 -c 1 -t 3 -d 0 $d
        et1=$(date +%s)

        duration1=$(expr $et1 - $st1)
        echo Ping of $d took $duration1 sec.

        if [ "$duration1" -gt "1" ]
        then
            # maybe it was disconnected normally?
            dd=`hcitool -i hci0 con | tr " " "\n" | grep $d`
            if [ "x$d" = "x$dd" ]
            then
                echo Re-check $d...
                st2=$(date +%s)
                l2ping -i hci0 -c 1 -t 3 -d 0 $d
                et2=$(date +%s)

                duration2=$(expr $et2 - $st2)
                echo Ping of $d took $duration2 sec.

                if [ "$duration1" -gt "1" ]
                then
                    echo BT broken.
                    touch /tmp/bt_broken
                fi 
            fi
        fi
        sleep 1
    done

    # check for rfcomm devices stuck in closed state
    for dev in `rfcomm -a | grep closed | sed 's/:.*//g'`
    do
        # only for incomming connection ports: /dev/rfcomm0 and /dev/rfcomm1
        if [ "$dev" == rfcomm0 ] || [ "$dev" == rfcomm1 ]
        then
            echo $dev stuck in closed state
            # find the pid of the corresponding rfcomm process
            pid=$(ps -o 'pid,args' | grep "\-i hci0 \-r watch /dev/$dev" | grep -v grep | awk '{print $1}')
            echo Killing process $pid
            kill $pid
        fi
    done

    # check that device is discoverable
    if ! hciconfig hci0 | grep "PSCAN ISCAN"
    then
        bluetoothctl <<EOF
discoverable on
discoverable-timeout 0
EOF
    fi

    sleep 1
    mknod -m 666 /dev/rfcomm0 c 216 0
    mknod -m 666 /dev/rfcomm1 c 216 1
    mknod -m 666 /dev/rfcomm2 c 216 2

done

