#!/bin/sh
# Copyright (C) 2013,2014 Tru-Test Ltd.  All rights reserved.

if [ $# -eq 0 -a ! -f /tmp/bt_init_done ]
then
        cat > /etc/bluetooth/main.conf << HEREDOC
[General]
Name = 5000
Class = 0x120114
DiscoverableTimeout = 0
PairableTimeout = 0
HEREDOC

        echo 117 > /sys/class/gpio/export
        sleep 0.1
        echo out > /sys/class/gpio/gpio117/direction
        sleep 0.1
        echo 0 > /sys/class/gpio/gpio117/value
        sleep 0.3
        echo 1 > /sys/class/gpio/gpio117/value
        sleep 0.3

        # This step loads the firmware/patches into the BT module.
        wifimodule=0
        if grep -qi 0x02d0 /tmp/wifivendor
        then
            wifimodule=1
        elif grep -qi 0x0097 /tmp/wifivendor
        then
            wifimodule=0
        fi
        ln -sf /mnt/nand/rootfs/lib/firmware/regulatory.db /lib/firmware
        ln -sf /mnt/nand/rootfs/lib/firmware/regulatory_fcc.db /lib/firmware
        if [ $wifimodule -eq 0 ]
        then
            ln -sf /mnt/nand/rootfs/lib/firmware/ti-connectivity /lib/firmware/
            sleep 1
            hciattach -s 115200 /dev/ttyS1 texas 3000000
        else
            ln -sf /mnt/nand/rootfs/lib/firmware/brcm /lib/firmware
            ln -sf /lib/firmware /etc
            setsid btattach -B /dev/ttyS1 -P bcm -S 3000000 < /dev/null > /dev/null 2> /dev/null &
            sleep 3
            #hciattach -s 115200 /dev/ttyS1 bcm43xx 3000000 || hciattach -s 115200 /dev/ttyS1 bcm43xx 3000000
        fi
        sleep 1

        bluetoothctl <<EOF
power on
discoverable on
discoverable-timeout 0
EOF
        # Doing "hciconfig hci0 piscan" doesnt work properly.
        # So use DBUS to set permanently Discoverable.
        # The time-out is disabled in /etc/bluetooth/main.conf
        #dbus-send --system --dest=org.bluez --print-reply --type=method_call /org/bluez/$(pidof bluetoothd)/hci0 org.bluez.Adapter.SetProperty string:Discoverable variant:boolean:true

        # Set BT name according to model.
        # This is only done once after powerup, so if the model is changed, it is necessary to cycle the power.
        # This should be acceptable.  If the model is not set, it will default to ID5000.
        if grep -qi XR /tmp/model
        then 
            hciconfig hci0 name XR5000
            echo -e "system-alias 'XR5000'" | bluetoothctl
        elif grep -qi ID /tmp/model
        then
            hciconfig hci0 name ID5000
            echo -e "system-alias 'ID5000'" | bluetoothctl
        else
            hciconfig hci0 name JR5000
            echo -e "system-alias 'JR5000'" | bluetoothctl
        fi

        # 2023-05-10 SSP mode required to be explicitly enabled for old TI module
        hciconfig hci0 sspmode 1
        
        bluetoothctl <<EOF
agent off
EOF
        # for PIN number pairing...
        if [ ! -f /mnt/nand/bluetooth/pin.cfg ]
        then
            echo "* 0000" > /mnt/nand/bluetooth/pin.cfg
        fi
        setsid bt-agent -c NoInputNoOutput -p /mnt/nand/bluetooth/pin.cfg < /dev/null > /dev/null 2> /dev/null &
        #agent 0000 &

        sdptool del 0x10010
        sdptool add --handle=0x10010 --channel=1 SP

        # run rfcomm in a backgrounded loop, so it will be restarted if killed
        setsid /mnt/nand/bluetooth/rfcomm.sh rfcomm0 1 < /dev/null > /dev/null 2> /dev/null &
        setsid /mnt/nand/bluetooth/rfcomm.sh rfcomm1 2 < /dev/null > /dev/null 2> /dev/null &

        # To conenct to your XR5000, do this on your Ubuntu VM:
        # Find your XR5000:
        #     hcitool scan
        # If there is already a rfcomm0 connection, release it:
        #     sudo rfcomm -a
        #     sudo rfcomm release /dev/rfcomm0
        # Bind to your XR5000 on port 3:
        #     sudo rfcomm bind /dev/rfcomm0 34:B1:F7:6B:75:9B 3
        #     sudo rfcomm -a
        # Connect:
        #     minicom -o -b 115200 -D /dev/rfcomm0

        # Start a login on port 3:
        setsid rfcomm -i hci0 watch /dev/rfcomm2 3 setsid /sbin/getty -n -L 115200 {} vt100 < /dev/null > /dev/null 2> /dev/null &

        # BT Class of Device:
        #     Service Classes: Networking, Object Transfer
        #     Device Class: Computer, Palm
        hciconfig hci0 class 0x120114

        # set inquiry and paging windows
        hciconfig hci0 inqparms 180:4096
        hciconfig hci0 pageparms 180:2048

        echo Advertising SP channel:
        setsid /mnt/nand/bluetooth/advertiser.sh < /dev/null > /dev/null 2> /dev/null &
        setsid /mnt/nand/bluetooth/btmon.sh < /dev/null > /dev/null 2> /dev/null &

        echo > /tmp/bt_init_done

        sleep 3
fi


if [ "$1" == "off" ]
then
    # close any channels first...
    # may help with Linux crash seen when doing hciconfig hci0 down?

    # echo `date +'%Y-%m-%d %H:%M:%S'` Doing bt.sh off >> /mnt/nand/logfiles/bt.log
    for d in `hcitool -i hci0 con | tr " " "\n" | grep ..:..:..:..:..:..`
    do 
        # echo `date +'%Y-%m-%d %H:%M:%S'` Closing connection to: $d >> /mnt/nand/logfiles/bt.log
        hcitool -i hci0 dc $d
    done

    hciconfig hci0 down
fi

if [ "$1" == "on" ]
then
    hciconfig hci0 up
    # 2023-05-10 SSP mode required to be explicitly enabled for old TI module
    hciconfig hci0 sspmode 1
fi

